// This script runs on aeoextension.com
// It listens for the auth state and sends the token to the extension background.

console.log('[AEO-Sync] Auth sync script loaded');

// Function to send auth to extension
function syncAuth(user) {
    if (user) {
        user.getIdToken().then(token => {
            chrome.runtime.sendMessage({
                action: 'auth_sync',
                token: token,
                uid: user.uid,
                email: user.email
            }, (response) => {
                console.log('[AEO-Sync] Auth synced:', response);
            });
        });
    } else {
        chrome.runtime.sendMessage({ action: 'auth_logout' });
    }
}

// If the website uses Firebase Auth, we can hook into onAuthStateChanged
// Note: This assumes the website's firebase instance is accessible or we are injecting/polling.
// A common approach is to check localStorage or wait for a custom event from the site.

// For demonstration, let's assume the site exposes it or we poll localStorage
function checkLocalStorage() {
    const firebaseAuthKey = Object.keys(localStorage).find(key => key.startsWith('firebase:authUser'));
    if (firebaseAuthKey) {
        const authData = JSON.parse(localStorage.getItem(firebaseAuthKey));
        if (authData) {
            chrome.runtime.sendMessage({
                action: 'auth_sync',
                token: authData.stsTokenManager.accessToken,
                uid: authData.uid,
                email: authData.email
            });
        }
    }
}

// Poll once on load
checkLocalStorage();

// Also listen for custom events from the website if it wants to proactively sync
window.addEventListener('aeo_auth_changed', (event) => {
    if (event.detail && event.detail.token) {
        chrome.runtime.sendMessage({
            action: 'auth_sync',
            token: event.detail.token,
            uid: event.detail.uid,
            email: event.detail.email
        });
    }
});
