# AEO Insights Chrome Extension

A diagnostic tool for Answer Engine Optimization (AEO). Helps users understand how "Answer-Ready" a webpage is for AI answer engines like ChatGPT, Claude, and Perplexity.

## Features

- **Answer Readiness Score (0-100)**: Visual assessment of content clarity for AI extraction
- **Critical Insights**: Identifies structural and clarity issues
- **Confusing Zones**: Highlights sections with ambiguous or context-dependent content
- **AI Preview**: Shows example of how AI systems might extract and summarize content
- **Entity Map**: Detects and lists entities (companies, dates, locations, products)
- **Direct Citation**: Generates reference links for the strongest answer blocks
- **Analysis History**: Local-only storage of past analyses with URL and score
- **Subscription UI**: Free/Paid tier distinction (UI only, no payment processing)

## File Structure

```
├── manifest.json       # Extension configuration
├── popup.html          # Popup UI
├── popup.css           # Popup styles
├── popup.js            # Popup logic & state management
├── content.js          # Content extraction script
├── background.js       # Service worker for background tasks
└── README.md           # This file
```

## How It Works

### User Flow

1. User clicks "Analyze This Page" button
2. Extension analyzes the visible page content
3. Results show AEO Score and quick insights
4. User can expand to see full analysis panel
5. Data saved locally in browser

### Core Analysis Signals

- **Q&A Readiness**: Is there a clear question-answer structure?
- **Answer Blocks**: Are answers concise (40-60 words) and factual?
- **Entity Clarity**: Are names, brands, and dates clear without pronoun overload?
- **Information Density**: Facts-first vs marketing fluff ratio
- **Simple Language**: AI-friendly, neutral tone

## Technical Details

### Permissions Used
- `activeTab`: Access to current tab only
- `scripting`: Run content scripts on pages
- `storage`: Save local analysis history

### Data Privacy
- Analysis results shown then discarded
- History stored locally in browser only
- No server-side storage
- No content text storage (only URL and score)

### Language Support
- English-only in v1
- Non-English pages show informational notice

## Installation for Development

1. Clone or download this repository
2. Open `chrome://extensions/` in Chrome
3. Enable "Developer mode" (top right)
4. Click "Load unpacked"
5. Select the directory containing these files

## Usage

### For Users

1. Navigate to any webpage
2. Click the AEO Insights icon in your toolbar
3. Click "Analyze This Page"
4. View results in the popup or expanded panel
5. Use "Generate Reference Link" to create a citation

### For Developers

- **Mock Data**: Analysis currently uses placeholder data
- **Real Analysis**: Replace `generateMockAnalysis()` in popup.js with actual analysis logic
- **Styling**: Use CSS variables in popup.css for easy theme adjustments
- **Storage**: Uses `localStorage` for history; migrate to `chrome.storage` for sync across devices

## Limitations

- Does NOT guarantee rankings or traffic increases
- Does NOT verify factual accuracy of content
- Does NOT provide SEO metrics
- Does NOT auto-rewrite or suggest edits
- Medical, drug, and movie content shows reduced accuracy notice

## Future Enhancements

- [ ] Real analysis algorithm implementation
- [ ] Backend sync for cloud storage (optional)
- [ ] Subscription tier functionality
- [ ] Batch analysis of multiple pages
- [ ] Export reports
- [ ] Multi-language support

## Disclaimer

AEO analysis is a diagnostic tool for content clarity. It does not guarantee inclusion in AI answer engines, ranking improvements, or traffic increases.

---

**Version**: 1.0.0  
**Last Updated**: 2024
